unit disque_vierge;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TDisquette_vierge = class(TForm)
    label_faces: TLabel;
    label_secteurs: TLabel;
    label_pistes: TLabel;
    label_taille_secteurs: TLabel;
    choix_faces: TComboBox;
    choix_secteurs: TComboBox;
    choix_pistes: TComboBox;
    cmd_disquette_vierge: TButton;
    choix_taille_secteurs: TComboBox;
    ouvrir_disquette: TCheckBox;
    label_entrees_rep_principal: TLabel;
    choix_entrees_rep_principal: TComboBox;
    label_secteurs_par_cluster: TLabel;
    choix_secteurs_par_cluster: TComboBox;
    label_taille_disquette: TLabel;
    aff_taille_disquette: TLabel;
    label_espace_disponible: TLabel;
    aff_espace_disponible: TLabel;
    label_secteurs_par_fat: TLabel;
    choix_secteurs_par_fat: TComboBox;
    procedure FormDeactivate(Sender: TObject);
    procedure cmd_disquette_viergeClick(Sender: TObject);
    procedure choix_facesChange(Sender: TObject);
    procedure choix_entrees_rep_principalChange(Sender: TObject);
    procedure choix_pistesChange(Sender: TObject);
    procedure choix_secteursChange(Sender: TObject);
    procedure choix_secteurs_par_clusterChange(Sender: TObject);
    procedure choix_taille_secteursChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure choix_secteurs_par_fatChange(Sender: TObject);
  private
    { Dclarations prives }
    procedure affichage_taille_disquette;
  public
    { Dclarations publiques }
  end;

var
  Disquette_vierge: TDisquette_vierge;

implementation

uses main, traduction, tout, childwin, config;

{$R *.dfm}

//Fermeture de la fentre sur perte de la focalisation
procedure TDisquette_vierge.FormDeactivate(Sender: TObject);
begin
    ecrit_ini_disquette_vierge;
    close;
end;

//Cration d'une image disque vierge
procedure TDisquette_vierge.cmd_disquette_viergeClick(Sender: TObject);
var
    faces:smallint;
    secteurs:smallint;
    pistes:smallint;
    taille_secteur:smallint;
    secteurs_par_cluster:smallint;
    entrees_rep_principal:smallint;
    secteurs_par_fat:byte;
    nomfichier:string;

begin
    faces:=strtoint(choix_faces.Text);
    secteurs:=strtoint(choix_secteurs.Text);
    pistes:=strtoint(choix_pistes.Text);
    taille_secteur:=strtoint(choix_taille_secteurs.Text);
    secteurs_par_cluster:=strtoint(choix_secteurs_par_cluster.Text);
    entrees_rep_principal:=strtoint(choix_entrees_rep_principal.Text);
    secteurs_par_fat:=strtoint(choix_secteurs_par_fat.Text);

    MSA_Converter.selecfichier.title:=textes_nouvelle_disquette[14];
    MSA_Converter.selecfichier.filter:=textes_nouvelle_disquette[15];
    MSA_Converter.selecfichier.fileName:=textes_nouvelle_disquette[13];
    MSA_Converter.selecfichier.DefaultExt :='st';
    MSA_Converter.selecfichier.options:=[ofPathMustExist,ofHideReadOnly];
    MSA_Converter.selecfichier.InitialDir:=rep_utilisateur;

    if MSA_Converter.selecfichier.Execute=true then
    begin
        nomfichier:=MSA_Converter.selecfichier.fileName;
        rep_utilisateur:=extraire_repertoire(nomfichier);
        creation_disquette_vierge(faces,secteurs,pistes,taille_secteur,secteurs_par_cluster,
                                    entrees_rep_principal,secteurs_par_fat,nomfichier);
        if ouvrir_disquette.Checked=true then TMDIChild.Create(Application);
    end;
    close;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_facesChange(Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_entrees_rep_principalChange(
  Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_pistesChange(Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_secteursChange(Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_secteurs_par_clusterChange(
  Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_taille_secteursChange(Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos sur changement de paramtre
procedure TDisquette_vierge.choix_secteurs_par_fatChange(Sender: TObject);
begin
    affichage_taille_disquette;
end;

//Demande de rafraichissement des infos  la cration de la fentre
procedure TDisquette_vierge.FormCreate(Sender: TObject);
begin
    lit_ini_disquette_vierge;
    traduction_textes_nouvelle_disquette;
    affichage_taille_disquette;
end;

//Rafraichissement des infos de taille de la disquette
procedure TDisquette_vierge.affichage_taille_disquette;
var
    faces:smallint;
    secteurs:smallint;
    pistes:smallint;
    taille_secteur:smallint;
    entrees_rep_principal:smallint;
    secteurs_par_cluster:smallint;
    fats:smallint;
    secteurs_par_fat:smallint;
    taille_totale:integer;
    espace_disponible:integer;
    nombre_clusters:integer;
    calc:integer;

begin
    fats:=2;
    secteurs_par_fat:=strtoint(choix_secteurs_par_fat.text);
    faces:=strtoint(choix_faces.Text);
    secteurs:=strtoint(choix_secteurs.Text);
    pistes:=strtoint(choix_pistes.Text);
    taille_secteur:=strtoint(choix_taille_secteurs.Text);
    entrees_rep_principal:=strtoint(choix_entrees_rep_principal.Text);
    secteurs_par_cluster:=strtoint(choix_secteurs_par_cluster.Text);

    taille_totale:=faces*secteurs*pistes*taille_secteur;
    aff_taille_disquette.Caption:=inttostr(taille_totale)+textes_nouvelle_disquette[10];

    calc:=entrees_rep_principal shr 4;      // Rpertoire principal
    inc(calc);                              // Bootsecteur
    inc(calc,fats*secteurs_par_fat);        // Les deux FATs
    if odd(calc) then inc(calc);            // Nombre toujours pair
    if secteurs_par_cluster=2 then calc:=calc shr 1;
    nombre_clusters:=(secteurs*faces*pistes) div secteurs_par_cluster;
    dec(nombre_clusters,calc);              //Rpertoire principal + FATs (voir ci-dessus)
    dec(nombre_clusters,2);

    espace_disponible:=nombre_clusters*taille_secteur*secteurs_par_cluster;
    aff_espace_disponible.Caption:=inttostr(espace_disponible)+textes_nouvelle_disquette[10];
end;

end.
